/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import org.jpos.iso.ISOBitMapPackager;
import org.jpos.iso.ISOComponent;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOUtil;

public class IFA_BITMAP
extends ISOBitMapPackager {
    public IFA_BITMAP() {
    }

    public IFA_BITMAP(int len, String description) {
        super(len, description);
    }

    @Override
    public byte[] pack(ISOComponent c) throws ISOException {
        byte[] b = ISOUtil.bitSet2byte((BitSet)c.getValue());
        return ISOUtil.hexString(b).getBytes();
    }

    @Override
    public int getMaxPackedLength() {
        return this.getLength() >> 2;
    }

    @Override
    public int unpack(ISOComponent c, byte[] b, int offset) throws ISOException {
        int len;
        BitSet bmap = ISOUtil.hex2BitSet(b, offset, this.getLength() << 3);
        c.setValue(bmap);
        int n = len = bmap.get(1) ? 128 : 64;
        if (this.getLength() > 16 && bmap.get(65)) {
            len = 192;
        }
        return len >> 2;
    }

    @Override
    public void unpack(ISOComponent c, InputStream in) throws IOException, ISOException {
        BitSet bmap = ISOUtil.hex2BitSet(new BitSet(64), this.readBytes(in, 16), 0);
        if (this.getLength() > 8 && bmap.get(1)) {
            ISOUtil.hex2BitSet(bmap, this.readBytes(in, 16), 64);
        }
        c.setValue(bmap);
    }
}

