/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;
import java.util.Vector;
import org.jpos.iso.FilteredChannel;
import org.jpos.iso.ISOFilter;
import org.jpos.iso.ISOMsg;
import org.jpos.util.LogEvent;

public abstract class FilteredBase
extends Observable
implements FilteredChannel,
Cloneable {
    protected Vector incomingFilters = new Vector();
    protected Vector outgoingFilters = new Vector();

    private void addFilter(ISOFilter filter, int direction) {
        switch (direction) {
            case 1: {
                this.incomingFilters.add(filter);
                break;
            }
            case 2: {
                this.outgoingFilters.add(filter);
                break;
            }
            case 0: {
                this.incomingFilters.add(filter);
                this.outgoingFilters.add(filter);
            }
        }
    }

    @Override
    public void addIncomingFilter(ISOFilter filter) {
        this.addFilter(filter, 1);
    }

    @Override
    public void addOutgoingFilter(ISOFilter filter) {
        this.addFilter(filter, 2);
    }

    @Override
    public void addFilter(ISOFilter filter) {
        this.addFilter(filter, 0);
    }

    private void removeFilter(ISOFilter filter, int direction) {
        switch (direction) {
            case 1: {
                this.incomingFilters.remove(filter);
                break;
            }
            case 2: {
                this.outgoingFilters.remove(filter);
                break;
            }
            case 0: {
                this.incomingFilters.remove(filter);
                this.outgoingFilters.remove(filter);
            }
        }
    }

    @Override
    public void removeFilter(ISOFilter filter) {
        this.removeFilter(filter, 0);
    }

    @Override
    public void removeIncomingFilter(ISOFilter filter) {
        this.removeFilter(filter, 1);
    }

    @Override
    public void removeOutgoingFilter(ISOFilter filter) {
        this.removeFilter(filter, 2);
    }

    protected ISOMsg applyOutgoingFilters(ISOMsg m, LogEvent evt) throws ISOFilter.VetoException {
        Iterator iter = this.outgoingFilters.iterator();
        while (iter.hasNext()) {
            m.setDirection(2);
            m = ((ISOFilter)iter.next()).filter(this, m, evt);
        }
        m.setDirection(2);
        this.setChanged();
        this.notifyObservers(m);
        return m;
    }

    protected ISOMsg applyIncomingFilters(ISOMsg m, LogEvent evt) throws ISOFilter.VetoException {
        Iterator iter = this.incomingFilters.iterator();
        while (iter.hasNext()) {
            m.setDirection(1);
            m = ((ISOFilter)iter.next()).filter(this, m, evt);
        }
        m.setDirection(1);
        this.setChanged();
        this.notifyObservers(m);
        return m;
    }

    @Override
    public Collection getIncomingFilters() {
        return this.incomingFilters;
    }

    @Override
    public Collection getOutgoingFilters() {
        return this.outgoingFilters;
    }

    @Override
    public void setIncomingFilters(Collection filters) {
        this.incomingFilters = new Vector(filters);
    }

    @Override
    public void setOutgoingFilters(Collection filters) {
        this.outgoingFilters = new Vector(filters);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

