/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.util.Map;
import org.jdom.JDOMException;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOMsg;
import org.jpos.util.FSDMsg;

public class FSDISOMsg
extends ISOMsg
implements Cloneable {
    FSDMsg fsd;
    private static final long serialVersionUID = 1L;

    public FSDISOMsg() {
    }

    public FSDISOMsg(FSDMsg fsd) {
        this.fsd = fsd;
    }

    @Override
    public String getMTI() {
        return this.getString(0);
    }

    @Override
    public byte[] pack() throws ISOException {
        try {
            return this.fsd.packToBytes();
        }
        catch (Exception e) {
            throw new ISOException(e);
        }
    }

    @Override
    public int unpack(byte[] b) throws ISOException {
        try {
            this.fsd.unpack(b);
            return b.length;
        }
        catch (Exception e) {
            throw new ISOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpack(InputStream in) throws IOException, ISOException {
        FSDISOMsg fSDISOMsg = this;
        synchronized (fSDISOMsg) {
            try {
                this.fsd.unpack(in);
            }
            catch (JDOMException e) {
                throw new ISOException(e);
            }
        }
    }

    public FSDMsg getFSDMsg() {
        return this.fsd;
    }

    @Override
    public String getString(int fldno) {
        return this.fsd.get(Integer.toString(fldno));
    }

    @Override
    public String getString(String fld) {
        return this.fsd.get(fld);
    }

    @Override
    public boolean hasField(int fldno) {
        return this.getString(fldno) != null;
    }

    @Override
    public boolean hasField(String fld) {
        return this.getString(fld) != null;
    }

    @Override
    public void dump(PrintStream p, String indent) {
        if (this.fsd != null) {
            this.fsd.dump(p, indent);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeUTF(this.fsd.getBasePath());
        out.writeUTF(this.fsd.getBaseSchema());
        out.writeObject(this.fsd.getMap());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        String basePath = in.readUTF();
        String baseSchema = in.readUTF();
        this.fsd = new FSDMsg(basePath, baseSchema);
        Map map = (Map)in.readObject();
        for (Map.Entry entry : map.entrySet()) {
            this.fsd.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public Object clone() {
        FSDISOMsg m = (FSDISOMsg)super.clone();
        m.fsd = (FSDMsg)this.fsd.clone();
        return m;
    }

    @Override
    public Object clone(int[] fields) {
        FSDISOMsg m = (FSDISOMsg)super.clone();
        m.fsd = new FSDMsg(this.fsd.getBasePath(), this.fsd.getBaseSchema());
        for (int field : fields) {
            String f = Integer.toString(field);
            m.fsd.set(f, this.fsd.get(f));
        }
        return m;
    }

    @Override
    public void merge(ISOMsg m) {
        if (m instanceof FSDISOMsg) {
            this.fsd.merge(((FSDISOMsg)m).getFSDMsg());
        } else {
            for (int i = 0; i <= m.getMaxField(); ++i) {
                if (!m.hasField(i)) continue;
                this.fsd.set(Integer.toString(i), m.getString(i));
            }
        }
    }

    @Override
    public void setResponseMTI() {
        try {
            super.setResponseMTI();
        }
        catch (ISOException iSOException) {
            // empty catch block
        }
    }

    @Override
    public void set(String name, String value) {
        if (value != null) {
            this.fsd.set(name, value);
        }
    }
}

