/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import org.jpos.iso.Prefixer;

public class EbcdicPrefixer
implements Prefixer {
    public static final EbcdicPrefixer LL = new EbcdicPrefixer(2);
    public static final EbcdicPrefixer LLL = new EbcdicPrefixer(3);
    public static final EbcdicPrefixer LLLL = new EbcdicPrefixer(4);
    private static byte[] EBCDIC_DIGITS = new byte[]{-16, -15, -14, -13, -12, -11, -10, -9, -8, -7};
    private int nDigits;

    public EbcdicPrefixer(int nDigits) {
        this.nDigits = nDigits;
    }

    @Override
    public void encodeLength(int length, byte[] b) {
        for (int i = this.nDigits - 1; i >= 0; --i) {
            b[i] = EBCDIC_DIGITS[length % 10];
            length /= 10;
        }
    }

    @Override
    public int decodeLength(byte[] b, int offset) {
        int len = 0;
        for (int i = 0; i < this.nDigits; ++i) {
            len = len * 10 + (b[offset + i] & 0xF);
        }
        return len;
    }

    @Override
    public int getPackedLength() {
        return this.nDigits;
    }
}

