/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import org.jpos.iso.BinaryInterpreter;

public class EbcdicHexInterpreter
implements BinaryInterpreter {
    public static final EbcdicHexInterpreter INSTANCE = new EbcdicHexInterpreter();
    private static final byte[] HEX_EBCDIC = new byte[]{-16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -63, -62, -61, -60, -59, -58};

    @Override
    public void interpret(byte[] data, byte[] b, int offset) {
        for (int i = 0; i < data.length; ++i) {
            b[offset + i * 2] = HEX_EBCDIC[(data[i] & 0xF0) >> 4];
            b[offset + i * 2 + 1] = HEX_EBCDIC[data[i] & 0xF];
        }
    }

    @Override
    public byte[] uninterpret(byte[] rawData, int offset, int length) {
        byte[] ret = new byte[length];
        for (int i = 0; i < length; ++i) {
            byte hi = rawData[offset + i * 2];
            byte lo = rawData[offset + i * 2 + 1];
            int h = hi < 240 ? 10 + hi - 192 : hi - 240;
            int l = lo < 240 ? 10 + lo - 192 : lo - 240;
            ret[i] = (byte)(h << 4 | l);
        }
        return ret;
    }

    @Override
    public int getPackedLength(int nBytes) {
        return nBytes * 2;
    }
}

