/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.Serializable;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOUtil;

public class Currency
implements Serializable {
    String alphacode;
    int isocode;
    int numdecimals;

    public Currency(String alphacode, int isocode, int numdecimals) {
        this.alphacode = alphacode;
        this.isocode = isocode;
        this.numdecimals = numdecimals;
    }

    public int getDecimals() {
        return this.numdecimals;
    }

    public int getIsoCode() {
        return this.isocode;
    }

    public String getAlphaCode() {
        return this.alphacode;
    }

    public String formatAmountForISOMsg(double amount) {
        try {
            double m = Math.pow(10.0, this.getDecimals()) * amount;
            return ISOUtil.zeropad(String.valueOf(Math.round(m)), 12);
        }
        catch (ISOException e) {
            throw new IllegalArgumentException("Failed to convert amount", e);
        }
    }

    public double parseAmountFromISOMsg(String isoamount) {
        return new Double(isoamount) / Math.pow(10.0, this.getDecimals());
    }

    public String toString() {
        return "Currency{alphacode='" + this.alphacode + '\'' + ", isocode=" + this.isocode + ", numdecimals=" + this.numdecimals + '}';
    }
}

