/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.IOException;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.Channel;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISORequestListener;
import org.jpos.iso.ISOSource;
import org.jpos.iso.MUX;
import org.jpos.util.LogEvent;
import org.jpos.util.LogSource;
import org.jpos.util.Logger;
import org.jpos.util.NameRegistrar;
import org.jpos.util.ThreadPool;

public class Connector
implements ISORequestListener,
LogSource,
Configurable {
    private Logger logger;
    private String realm;
    private boolean preserveSourceHeader = true;
    protected String muxName;
    protected String channelName;
    protected int timeout = 0;
    protected static ThreadPool pool;

    @Override
    public void setLogger(Logger logger, String realm) {
        this.logger = logger;
        this.realm = realm;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.timeout = cfg.getInt("timeout");
        if (pool == null) {
            pool = new ThreadPool(1, cfg.getInt("poolsize", 10));
        }
        this.muxName = cfg.get("destination-mux", null);
        this.channelName = cfg.get("destination-channel", null);
        this.preserveSourceHeader = cfg.getBoolean("preserve-source-header", true);
        if (this.muxName == null && this.channelName == null) {
            throw new ConfigurationException("Neither destination mux nor channel were specified.");
        }
    }

    @Override
    public boolean process(ISOSource source, ISOMsg m) {
        if (pool == null) {
            pool = new ThreadPool(1, 10);
        }
        pool.execute(new Process(source, m));
        return true;
    }

    protected class Process
    implements Runnable {
        ISOSource source;
        ISOMsg m;

        Process(ISOSource source, ISOMsg m) {
            this.source = source;
            this.m = m;
        }

        @Override
        public void run() {
            LogEvent evt = new LogEvent(Connector.this, "connector-request-listener");
            try {
                ISOMsg c = (ISOMsg)this.m.clone();
                evt.addMessage(c);
                if (Connector.this.muxName != null) {
                    MUX destMux = (MUX)NameRegistrar.get(Connector.this.muxName);
                    ISOMsg response = destMux.request(c, Connector.this.timeout);
                    if (response != null) {
                        if (Connector.this.preserveSourceHeader) {
                            response.setHeader(c.getISOHeader());
                        }
                        this.source.send(response);
                    }
                } else if (Connector.this.channelName != null) {
                    Channel destChannel = (Channel)NameRegistrar.get(Connector.this.channelName);
                    destChannel.send(c);
                }
            }
            catch (ISOException e) {
                evt.addMessage(e);
            }
            catch (IOException e) {
                evt.addMessage(e);
            }
            catch (NameRegistrar.NotFoundException e) {
                evt.addMessage(e);
            }
            Logger.log(evt);
        }
    }
}

