/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import org.jpos.iso.Prefixer;

public class BcdPrefixer
implements Prefixer {
    public static final BcdPrefixer L = new BcdPrefixer(1);
    public static final BcdPrefixer LL = new BcdPrefixer(2);
    public static final BcdPrefixer LLL = new BcdPrefixer(3);
    public static final BcdPrefixer LLLL = new BcdPrefixer(4);
    public static final BcdPrefixer LLLLL = new BcdPrefixer(5);
    private int nDigits;

    public BcdPrefixer(int nDigits) {
        this.nDigits = nDigits;
    }

    @Override
    public void encodeLength(int length, byte[] b) {
        for (int i = this.getPackedLength() - 1; i >= 0; --i) {
            int twoDigits = length % 100;
            length /= 100;
            b[i] = (byte)((twoDigits / 10 << 4) + twoDigits % 10);
        }
    }

    @Override
    public int decodeLength(byte[] b, int offset) {
        int len = 0;
        for (int i = 0; i < (this.nDigits + 1) / 2; ++i) {
            len = 100 * len + ((b[offset + i] & 0xF0) >> 4) * 10 + (b[offset + i] & 0xF);
        }
        return len;
    }

    @Override
    public int getPackedLength() {
        return this.nDigits + 1 >> 1;
    }
}

