/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;
import java.util.Vector;
import javax.net.ssl.SSLSocket;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.BaseChannelMBean;
import org.jpos.iso.ClientChannel;
import org.jpos.iso.FactoryChannel;
import org.jpos.iso.FilteredChannel;
import org.jpos.iso.ISOChannel;
import org.jpos.iso.ISOClientSocketFactory;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOFilter;
import org.jpos.iso.ISOHeader;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOPackager;
import org.jpos.iso.ISOUtil;
import org.jpos.iso.RawIncomingFilter;
import org.jpos.iso.ServerChannel;
import org.jpos.iso.header.BaseHeader;
import org.jpos.util.LogEvent;
import org.jpos.util.LogSource;
import org.jpos.util.Logger;
import org.jpos.util.NameRegistrar;

public abstract class BaseChannel
extends Observable
implements FilteredChannel,
ClientChannel,
ServerChannel,
FactoryChannel,
LogSource,
Configurable,
BaseChannelMBean,
Cloneable {
    private Socket socket;
    private String host;
    private String localIface;
    private String[] hosts;
    private int[] ports;
    private int port;
    private int timeout;
    private int connectTimeout;
    private int localPort;
    private int maxPacketLength = 100000;
    private boolean keepAlive;
    private boolean soLingerOn = true;
    private int soLingerSeconds = 5;
    private Configuration cfg;
    protected boolean usable;
    protected boolean overrideHeader;
    private String name = "";
    protected DataInputStream serverIn;
    protected DataOutputStream serverOut;
    protected Object serverInLock = new Object();
    protected Object serverOutLock = new Object();
    protected ISOPackager packager;
    protected ServerSocket serverSocket = null;
    protected Vector incomingFilters;
    protected Vector outgoingFilters;
    protected ISOClientSocketFactory socketFactory = null;
    protected int[] cnt = new int[3];
    protected Logger logger = null;
    protected String realm = null;
    protected String originalRealm = null;
    protected byte[] header = null;
    private static final int DEFAULT_TIMEOUT = 300000;

    public BaseChannel() {
        this.incomingFilters = new Vector();
        this.outgoingFilters = new Vector();
        this.setHost(null, 0);
    }

    public BaseChannel(String host, int port, ISOPackager p) {
        this();
        this.setHost(host, port);
        this.setPackager(p);
    }

    public BaseChannel(ISOPackager p) throws IOException {
        this();
        this.setPackager(p);
    }

    public BaseChannel(ISOPackager p, ServerSocket serverSocket) throws IOException {
        this();
        this.setPackager(p);
        this.setServerSocket(serverSocket);
    }

    @Override
    public void setHost(String host, int port) {
        this.host = host;
        this.port = port;
        this.hosts = new String[]{host};
        this.ports = new int[]{port};
    }

    public void setLocalAddress(String iface, int port) {
        this.localIface = iface;
        this.localPort = port;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
        this.hosts = new String[]{host};
    }

    @Override
    public void setPort(int port) {
        this.port = port;
        this.ports = new int[]{port};
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPackager(ISOPackager p) {
        this.packager = p;
    }

    @Override
    public ISOPackager getPackager() {
        return this.packager;
    }

    public void setServerSocket(ServerSocket sock) {
        this.setHost(null, 0);
        this.serverSocket = sock;
        this.name = "";
    }

    public void resetCounters() {
        for (int i = 0; i < 3; ++i) {
            this.cnt[i] = 0;
        }
    }

    public int[] getCounters() {
        return this.cnt;
    }

    @Override
    public boolean isConnected() {
        return this.socket != null && this.usable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect(Socket socket) throws IOException {
        this.socket = socket;
        this.applyTimeout();
        this.setLogger(this.getLogger(), this.getOriginalRealm() + "/" + socket.getInetAddress().getHostAddress() + ":" + socket.getPort());
        Object object = this.serverInLock;
        synchronized (object) {
            this.serverIn = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        }
        object = this.serverOutLock;
        synchronized (object) {
            this.serverOut = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream(), 2048));
        }
        this.postConnectHook();
        this.usable = true;
        this.cnt[0] = this.cnt[0] + 1;
        this.setChanged();
        this.notifyObservers();
    }

    protected void postConnectHook() throws IOException {
    }

    protected Socket newSocket(String host, int port) throws IOException {
        try {
            if (this.socketFactory != null) {
                return this.socketFactory.createSocket(host, port);
            }
            if (this.connectTimeout > 0) {
                Socket s = new Socket();
                s.connect(new InetSocketAddress(host, port), this.connectTimeout);
                return s;
            }
            if (this.localIface == null && this.localPort == 0) {
                return new Socket(host, port);
            }
            InetAddress addr = this.localIface == null ? InetAddress.getLocalHost() : InetAddress.getByName(this.localIface);
            return new Socket(host, port, addr, this.localPort);
        }
        catch (ISOException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected Socket newSocket(String[] hosts, int[] ports, LogEvent evt) throws IOException {
        Socket s = null;
        for (int i = 0; i < hosts.length; ++i) {
            try {
                evt.addMessage(hosts[i] + ":" + ports[i]);
                s = this.newSocket(hosts[i], ports[i]);
                break;
            }
            catch (IOException e) {
                evt.addMessage("  " + e.getMessage());
                continue;
            }
        }
        if (s == null) {
            throw new IOException("Unable to connect");
        }
        return s;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void setTimeout(int timeout) throws SocketException {
        this.timeout = timeout;
        this.applyTimeout();
    }

    public int getTimeout() {
        return this.timeout;
    }

    protected void applyTimeout() throws SocketException {
        if (this.socket != null) {
            this.socket.setKeepAlive(this.keepAlive);
            if (this.timeout >= 0) {
                this.socket.setSoTimeout(this.timeout);
            }
        }
    }

    public void setSoLinger(boolean on, int linger) {
        this.soLingerOn = on;
        this.soLingerSeconds = linger;
    }

    public boolean isSoLingerOn() {
        return this.soLingerOn;
    }

    public int getSoLingerSeconds() {
        return this.soLingerSeconds;
    }

    @Override
    public void connect() throws IOException {
        LogEvent evt = new LogEvent(this, "connect");
        try {
            if (this.serverSocket != null) {
                this.accept(this.serverSocket);
                evt.addMessage("local port " + this.serverSocket.getLocalPort() + " remote host " + this.socket.getInetAddress());
            } else {
                this.connect(this.newSocket(this.hosts, this.ports, evt));
            }
            this.applyTimeout();
            Logger.log(evt);
        }
        catch (ConnectException e) {
            Logger.log(new LogEvent(this, "connection-refused", this.getHost() + ":" + this.getPort()));
        }
        catch (IOException e) {
            evt.addMessage(e.getMessage());
            Logger.log(evt);
            throw e;
        }
    }

    @Override
    public void accept(ServerSocket s) throws IOException {
        Socket ss = s.accept();
        this.name = ss.getInetAddress().getHostAddress() + ":" + ss.getPort();
        this.connect(ss);
    }

    @Override
    public void setUsable(boolean b) {
        Logger.log(new LogEvent(this, "usable", b));
        this.usable = b;
    }

    protected ISOPackager getDynamicPackager(ISOMsg m) {
        return this.packager;
    }

    protected ISOPackager getDynamicPackager(byte[] image) {
        return this.packager;
    }

    protected ISOPackager getDynamicPackager(byte[] header, byte[] image) {
        return this.getDynamicPackager(image);
    }

    protected ISOHeader getDynamicHeader(byte[] image) {
        return image != null ? new BaseHeader(image) : null;
    }

    protected void sendMessageLength(int len) throws IOException {
    }

    protected void sendMessageHeader(ISOMsg m, int len) throws IOException {
        if (!this.isOverrideHeader() && m.getHeader() != null) {
            this.serverOut.write(m.getHeader());
        } else if (this.header != null) {
            this.serverOut.write(this.header);
        }
    }

    protected void sendMessageTrailler(ISOMsg m, int len) throws IOException {
    }

    protected void sendMessageTrailler(ISOMsg m, byte[] b) throws IOException {
        this.sendMessageTrailler(m, b.length);
    }

    protected void getMessageTrailler() throws IOException {
    }

    protected void getMessage(byte[] b, int offset, int len) throws IOException, ISOException {
        this.serverIn.readFully(b, offset, len);
    }

    protected int getMessageLength() throws IOException, ISOException {
        return -1;
    }

    protected int getHeaderLength() {
        return this.header != null ? this.header.length : 0;
    }

    protected int getHeaderLength(byte[] b) {
        return 0;
    }

    protected int getHeaderLength(ISOMsg m) {
        return !this.overrideHeader && m.getHeader() != null ? m.getHeader().length : this.getHeaderLength();
    }

    protected byte[] streamReceive() throws IOException {
        return new byte[0];
    }

    protected void sendMessage(byte[] b, int offset, int len) throws IOException {
        this.serverOut.write(b, offset, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(ISOMsg m) throws IOException, ISOException {
        LogEvent evt = new LogEvent(this, "send");
        try {
            if (!this.isConnected()) {
                throw new ISOException("unconnected ISOChannel");
            }
            m.setDirection(2);
            ISOPackager p = this.getDynamicPackager(m);
            m.setPackager(p);
            m = this.applyOutgoingFilters(m, evt);
            evt.addMessage(m);
            m.setDirection(2);
            m.setPackager(p);
            byte[] b = m.pack();
            Object object = this.serverOutLock;
            synchronized (object) {
                this.sendMessageLength(b.length + this.getHeaderLength(m));
                this.sendMessageHeader(m, b.length);
                this.sendMessage(b, 0, b.length);
                this.sendMessageTrailler(m, b);
                this.serverOut.flush();
            }
            this.cnt[1] = this.cnt[1] + 1;
            this.setChanged();
            this.notifyObservers(m);
        }
        catch (ISOFilter.VetoException e) {
            evt.addMessage(m);
            evt.addMessage(e);
            throw e;
        }
        catch (ISOException e) {
            evt.addMessage(e);
            throw e;
        }
        catch (IOException e) {
            evt.addMessage(e);
            throw e;
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw new ISOException("unexpected exception", e);
        }
        finally {
            Logger.log(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] b) throws IOException, ISOException {
        LogEvent evt = new LogEvent(this, "send");
        try {
            if (!this.isConnected()) {
                throw new ISOException("unconnected ISOChannel");
            }
            Object object = this.serverOutLock;
            synchronized (object) {
                this.serverOut.write(b);
                this.serverOut.flush();
            }
            this.cnt[1] = this.cnt[1] + 1;
            this.setChanged();
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw new ISOException("unexpected exception", e);
        }
        finally {
            Logger.log(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKeepAlive() throws IOException {
        Object object = this.serverOutLock;
        synchronized (object) {
            this.sendMessageLength(0);
            this.serverOut.flush();
        }
    }

    protected boolean isRejected(byte[] b) {
        return false;
    }

    protected boolean shouldIgnore(byte[] b) {
        return false;
    }

    protected ISOMsg createMsg() {
        return this.createISOMsg();
    }

    protected ISOMsg createISOMsg() {
        return this.packager.createISOMsg();
    }

    protected byte[] readHeader(int hLen) throws IOException {
        byte[] header = new byte[hLen];
        this.serverIn.readFully(header, 0, hLen);
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISOMsg receive() throws IOException, ISOException {
        byte[] b = null;
        byte[] header = null;
        LogEvent evt = new LogEvent(this, "receive");
        ISOMsg m = this.createMsg();
        m.setSource(this);
        try {
            if (!this.isConnected()) {
                throw new ISOException("unconnected ISOChannel");
            }
            Object object = this.serverInLock;
            synchronized (object) {
                int len = this.getMessageLength();
                int hLen = this.getHeaderLength();
                if (len == -1) {
                    if (hLen > 0) {
                        header = this.readHeader(hLen);
                    }
                    b = this.streamReceive();
                } else if (len > 0 && len <= this.getMaxPacketLength()) {
                    if (hLen > 0) {
                        header = this.readHeader(hLen);
                        len -= header.length;
                    }
                    b = new byte[len];
                    this.getMessage(b, 0, len);
                    this.getMessageTrailler();
                } else {
                    throw new ISOException("receive length " + len + " seems strange - maxPacketLength = " + this.getMaxPacketLength());
                }
            }
            m.setPackager(this.getDynamicPackager(header, b));
            m.setHeader(this.getDynamicHeader(header));
            if (b.length > 0 && !this.shouldIgnore(header)) {
                this.unpack(m, b);
            }
            m.setDirection(1);
            evt.addMessage(m);
            m = this.applyIncomingFilters(m, header, b, evt);
            m.setDirection(1);
            this.cnt[2] = this.cnt[2] + 1;
            this.setChanged();
            this.notifyObservers(m);
        }
        catch (ISOException e) {
            evt.addMessage(e);
            if (header != null) {
                evt.addMessage("--- header ---");
                evt.addMessage(ISOUtil.hexdump(header));
            }
            if (b != null) {
                evt.addMessage("--- data ---");
                evt.addMessage(ISOUtil.hexdump(b));
            }
            throw e;
        }
        catch (EOFException e) {
            this.closeSocket();
            evt.addMessage("<peer-disconnect/>");
            throw e;
        }
        catch (SocketException e) {
            this.closeSocket();
            if (this.usable) {
                evt.addMessage("<peer-disconnect>" + e.getMessage() + "</peer-disconnect>");
            }
            throw e;
        }
        catch (InterruptedIOException e) {
            this.closeSocket();
            evt.addMessage("<io-timeout/>");
            throw e;
        }
        catch (IOException e) {
            this.closeSocket();
            if (this.usable) {
                evt.addMessage(e);
            }
            throw e;
        }
        catch (Exception e) {
            evt.addMessage(m);
            evt.addMessage(e);
            throw new ISOException("unexpected exception", e);
        }
        finally {
            Logger.log(evt);
        }
        return m;
    }

    public int getBytes(byte[] b) throws IOException {
        return this.serverIn.read(b);
    }

    @Override
    public void disconnect() throws IOException {
        block9: {
            LogEvent evt = new LogEvent(this, "disconnect");
            if (this.serverSocket != null) {
                evt.addMessage("local port " + this.serverSocket.getLocalPort() + " remote host " + this.serverSocket.getInetAddress());
            } else {
                evt.addMessage(this.host + ":" + this.port);
            }
            try {
                this.usable = false;
                this.setChanged();
                this.notifyObservers();
                this.closeSocket();
                if (this.serverIn != null) {
                    try {
                        this.serverIn.close();
                    }
                    catch (IOException ex) {
                        evt.addMessage(ex);
                    }
                    this.serverIn = null;
                }
                if (this.serverOut == null) break block9;
                try {
                    this.serverOut.close();
                }
                catch (IOException ex) {
                    evt.addMessage(ex);
                }
                this.serverOut = null;
            }
            catch (IOException e) {
                evt.addMessage(e);
                Logger.log(evt);
                throw e;
            }
        }
        this.socket = null;
    }

    @Override
    public void reconnect() throws IOException {
        this.disconnect();
        this.connect();
    }

    @Override
    public void setLogger(Logger logger, String realm) {
        this.logger = logger;
        this.realm = realm;
        if (this.originalRealm == null) {
            this.originalRealm = realm;
        }
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public String getOriginalRealm() {
        return this.originalRealm == null ? this.getClass().getName() : this.originalRealm;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        NameRegistrar.register("channel." + name, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addFilter(ISOFilter filter, int direction) {
        switch (direction) {
            case 1: {
                this.incomingFilters.add(filter);
                break;
            }
            case 2: {
                this.outgoingFilters.add(filter);
                break;
            }
            case 0: {
                this.incomingFilters.add(filter);
                this.outgoingFilters.add(filter);
            }
        }
    }

    @Override
    public void addIncomingFilter(ISOFilter filter) {
        this.addFilter(filter, 1);
    }

    @Override
    public void addOutgoingFilter(ISOFilter filter) {
        this.addFilter(filter, 2);
    }

    @Override
    public void addFilter(ISOFilter filter) {
        this.addFilter(filter, 0);
    }

    public void removeFilter(ISOFilter filter, int direction) {
        switch (direction) {
            case 1: {
                this.incomingFilters.remove(filter);
                break;
            }
            case 2: {
                this.outgoingFilters.remove(filter);
                break;
            }
            case 0: {
                this.incomingFilters.remove(filter);
                this.outgoingFilters.remove(filter);
            }
        }
    }

    @Override
    public void removeFilter(ISOFilter filter) {
        this.removeFilter(filter, 0);
    }

    @Override
    public void removeIncomingFilter(ISOFilter filter) {
        this.removeFilter(filter, 1);
    }

    @Override
    public void removeOutgoingFilter(ISOFilter filter) {
        this.removeFilter(filter, 2);
    }

    protected ISOMsg applyOutgoingFilters(ISOMsg m, LogEvent evt) throws ISOFilter.VetoException {
        Iterator iter = this.outgoingFilters.iterator();
        while (iter.hasNext()) {
            m = ((ISOFilter)iter.next()).filter(this, m, evt);
        }
        return m;
    }

    protected ISOMsg applyIncomingFilters(ISOMsg m, LogEvent evt) throws ISOFilter.VetoException {
        return this.applyIncomingFilters(m, null, null, evt);
    }

    protected ISOMsg applyIncomingFilters(ISOMsg m, byte[] header, byte[] image, LogEvent evt) throws ISOFilter.VetoException {
        for (ISOFilter f : this.incomingFilters) {
            if (image != null && f instanceof RawIncomingFilter) {
                m = ((RawIncomingFilter)f).filter(this, m, header, image, evt);
                continue;
            }
            m = f.filter(this, m, evt);
        }
        return m;
    }

    protected void unpack(ISOMsg m, byte[] b) throws ISOException {
        m.unpack(b);
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
        String h = cfg.get("host");
        int port = cfg.getInt("port");
        this.maxPacketLength = cfg.getInt("max-packet-length", 100000);
        if (h != null && h.length() > 0) {
            if (port == 0) {
                throw new ConfigurationException("invalid port for host '" + h + "'");
            }
            this.setHost(h, port);
            this.setLocalAddress(cfg.get("local-iface", null), cfg.getInt("local-port"));
            String[] altHosts = cfg.getAll("alternate-host");
            int[] altPorts = cfg.getInts("alternate-port");
            this.hosts = new String[altHosts.length + 1];
            this.ports = new int[altPorts.length + 1];
            if (this.hosts.length != this.ports.length) {
                throw new ConfigurationException("alternate host/port misconfiguration");
            }
            this.hosts[0] = this.host;
            this.ports[0] = port;
            System.arraycopy(altHosts, 0, this.hosts, 1, altHosts.length);
            System.arraycopy(altPorts, 0, this.ports, 1, altPorts.length);
        }
        this.setOverrideHeader(cfg.getBoolean("override-header", false));
        this.keepAlive = cfg.getBoolean("keep-alive", false);
        if (this.socketFactory != this && this.socketFactory instanceof Configurable) {
            ((Configurable)((Object)this.socketFactory)).setConfiguration(cfg);
        }
        try {
            this.setTimeout(cfg.getInt("timeout", 300000));
            this.connectTimeout = cfg.getInt("connect-timeout", this.timeout);
        }
        catch (SocketException e) {
            throw new ConfigurationException(e);
        }
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }

    @Override
    public Collection getIncomingFilters() {
        return this.incomingFilters;
    }

    @Override
    public Collection getOutgoingFilters() {
        return this.outgoingFilters;
    }

    @Override
    public void setIncomingFilters(Collection filters) {
        this.incomingFilters = new Vector(filters);
    }

    @Override
    public void setOutgoingFilters(Collection filters) {
        this.outgoingFilters = new Vector(filters);
    }

    public void setHeader(byte[] header) {
        this.header = header;
    }

    public void setHeader(String header) {
        this.setHeader(header.getBytes());
    }

    public byte[] getHeader() {
        return this.header;
    }

    public void setOverrideHeader(boolean overrideHeader) {
        this.overrideHeader = overrideHeader;
    }

    public boolean isOverrideHeader() {
        return this.overrideHeader;
    }

    public static ISOChannel getChannel(String name) throws NameRegistrar.NotFoundException {
        return (ISOChannel)NameRegistrar.get("channel." + name);
    }

    public ISOClientSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    @Override
    public void setSocketFactory(ISOClientSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public int getMaxPacketLength() {
        return this.maxPacketLength;
    }

    public void setMaxPacketLength(int maxPacketLength) {
        this.maxPacketLength = maxPacketLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() throws IOException {
        Socket s = null;
        BaseChannel baseChannel = this;
        synchronized (baseChannel) {
            if (this.socket != null) {
                s = this.socket;
                this.socket = null;
            }
        }
        if (s != null) {
            try {
                s.setSoLinger(this.soLingerOn, this.soLingerSeconds);
                if (this.shutdownSupportedBySocket(s) && !this.isSoLingerForcingImmediateTcpReset()) {
                    s.shutdownOutput();
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            s.close();
        }
    }

    private boolean shutdownSupportedBySocket(Socket s) {
        return !(s instanceof SSLSocket);
    }

    private boolean isSoLingerForcingImmediateTcpReset() {
        return this.soLingerOn && this.soLingerSeconds == 0;
    }

    @Override
    public Object clone() {
        try {
            BaseChannel channel = (BaseChannel)super.clone();
            channel.cnt = (int[])this.cnt.clone();
            channel.serverInLock = new Object();
            channel.serverOutLock = new Object();
            channel.serverIn = null;
            channel.serverOut = null;
            channel.usable = false;
            channel.socket = null;
            return channel;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

