/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import org.jpos.iso.ISOUtil;
import org.jpos.iso.Interpreter;

public class BCDInterpreter
implements Interpreter {
    public static final BCDInterpreter LEFT_PADDED = new BCDInterpreter(true, false);
    public static final BCDInterpreter RIGHT_PADDED = new BCDInterpreter(false, false);
    public static final BCDInterpreter RIGHT_PADDED_F = new BCDInterpreter(false, true);
    public static final BCDInterpreter LEFT_PADDED_F = new BCDInterpreter(true, true);
    private boolean leftPadded;
    private boolean fPadded;

    private BCDInterpreter(boolean leftPadded, boolean fPadded) {
        this.leftPadded = leftPadded;
        this.fPadded = fPadded;
    }

    @Override
    public void interpret(String data, byte[] b, int offset) {
        ISOUtil.str2bcd(data, this.leftPadded, b, offset);
        int paddedSize = data.length() >> 1;
        if (this.fPadded && data.length() % 2 == 1) {
            if (this.leftPadded) {
                int n = offset;
                b[n] = (byte)(b[n] | 0xFFFFFFF0);
            } else {
                int n = offset + paddedSize;
                b[n] = (byte)(b[n] | 0xF);
            }
        }
    }

    @Override
    public String uninterpret(byte[] rawData, int offset, int length) {
        return ISOUtil.bcd2str(rawData, offset, length, this.leftPadded);
    }

    @Override
    public int getPackedLength(int nDataUnits) {
        return (nDataUnits + 1) / 2;
    }
}

