/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import org.jpos.iso.ISOException;
import org.jpos.iso.Prefixer;

public class AsciiPrefixer
implements Prefixer {
    public static final AsciiPrefixer L = new AsciiPrefixer(1);
    public static final AsciiPrefixer LL = new AsciiPrefixer(2);
    public static final AsciiPrefixer LLL = new AsciiPrefixer(3);
    public static final AsciiPrefixer LLLL = new AsciiPrefixer(4);
    public static final AsciiPrefixer LLLLL = new AsciiPrefixer(5);
    public static final AsciiPrefixer LLLLLL = new AsciiPrefixer(6);
    private int nDigits;

    public AsciiPrefixer(int nDigits) {
        this.nDigits = nDigits;
    }

    @Override
    public void encodeLength(int length, byte[] b) throws ISOException {
        int n = length;
        for (int i = this.nDigits - 1; i >= 0; --i) {
            b[i] = (byte)(n % 10 + 48);
            n /= 10;
        }
        if (n != 0) {
            throw new ISOException("invalid len " + length + ". Prefixing digits = " + this.nDigits);
        }
    }

    @Override
    public int decodeLength(byte[] b, int offset) {
        int len = 0;
        for (int i = 0; i < this.nDigits; ++i) {
            len = len * 10 + b[offset + i] - 48;
        }
        return len;
    }

    @Override
    public int getPackedLength() {
        return this.nDigits;
    }
}

