/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import java.io.UnsupportedEncodingException;
import org.jpos.iso.Interpreter;

public class AsciiInterpreter
implements Interpreter {
    public static final AsciiInterpreter INSTANCE = new AsciiInterpreter();

    @Override
    public void interpret(String data, byte[] b, int offset) {
        try {
            System.arraycopy(data.getBytes("ISO8859_1"), 0, b, offset, data.length());
        }
        catch (UnsupportedEncodingException ignored) {
            // empty catch block
        }
    }

    @Override
    public String uninterpret(byte[] rawData, int offset, int length) {
        byte[] ret = new byte[length];
        try {
            System.arraycopy(rawData, offset, ret, 0, length);
            return new String(ret, "ISO8859_1");
        }
        catch (UnsupportedEncodingException ignored) {
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException(String.format("Required %d but just got %d bytes", length, rawData.length - offset));
        }
        return null;
    }

    @Override
    public int getPackedLength(int nDataUnits) {
        return nDataUnits;
    }
}

