/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.iso;

import org.jpos.iso.BinaryInterpreter;

public class AsciiHexInterpreter
implements BinaryInterpreter {
    public static final AsciiHexInterpreter INSTANCE = new AsciiHexInterpreter();
    private static final byte[] HEX_ASCII = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    @Override
    public void interpret(byte[] data, byte[] b, int offset) {
        for (int i = 0; i < data.length; ++i) {
            b[offset + i * 2] = HEX_ASCII[(data[i] & 0xF0) >> 4];
            b[offset + i * 2 + 1] = HEX_ASCII[data[i] & 0xF];
        }
    }

    @Override
    public byte[] uninterpret(byte[] rawData, int offset, int length) {
        byte[] ret = new byte[length];
        for (int i = 0; i < length; ++i) {
            byte hi = rawData[offset + i * 2];
            byte lo = rawData[offset + i * 2 + 1];
            int h = hi > 64 ? 10 + hi - 65 : hi - 48;
            int l = lo > 64 ? 10 + lo - 65 : lo - 48;
            ret[i] = (byte)(h << 4 | l);
        }
        return ret;
    }

    @Override
    public int getPackedLength(int nBytes) {
        return nBytes * 2;
    }
}

