/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.core;

import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;

public class SubConfiguration
implements Configuration {
    protected Configuration cfg;
    protected String prefix;

    public SubConfiguration() {
    }

    public SubConfiguration(Configuration cfg, String prefix) {
        this.cfg = cfg;
        this.prefix = prefix;
    }

    public void setConfiguration(Configuration newCfg) {
        this.cfg = newCfg;
    }

    public void setPrefix(String newPrefix) {
        this.prefix = newPrefix;
    }

    @Override
    public String get(String propertyName) {
        return this.cfg.get(this.prefix + propertyName);
    }

    @Override
    public String[] getAll(String propertyName) {
        return this.cfg.getAll(this.prefix + propertyName);
    }

    @Override
    public int[] getInts(String propertyName) {
        return this.cfg.getInts(this.prefix + propertyName);
    }

    @Override
    public long[] getLongs(String propertyName) {
        return this.cfg.getLongs(this.prefix + propertyName);
    }

    @Override
    public double[] getDoubles(String propertyName) {
        return this.cfg.getDoubles(this.prefix + propertyName);
    }

    @Override
    public boolean[] getBooleans(String propertyName) {
        return this.cfg.getBooleans(this.prefix + propertyName);
    }

    @Override
    public String get(String propertyName, String defaultValue) {
        return this.cfg.get(this.prefix + propertyName, defaultValue);
    }

    @Override
    public boolean getBoolean(String propertyName) {
        return this.cfg.getBoolean(this.prefix + propertyName);
    }

    @Override
    public boolean getBoolean(String propertyName, boolean defaultValue) {
        return this.cfg.getBoolean(this.prefix + propertyName, defaultValue);
    }

    @Override
    public double getDouble(String propertyName) {
        return this.cfg.getDouble(this.prefix + propertyName);
    }

    @Override
    public double getDouble(String propertyName, double defaultValue) {
        return this.cfg.getDouble(this.prefix + propertyName, defaultValue);
    }

    @Override
    public long getLong(String propertyName) {
        return this.cfg.getLong(this.prefix + propertyName);
    }

    @Override
    public long getLong(String propertyName, long defaultValue) {
        return this.cfg.getLong(this.prefix + propertyName, defaultValue);
    }

    @Override
    public int getInt(String propertyName) {
        return this.cfg.getInt(this.prefix + propertyName);
    }

    @Override
    public int getInt(String propertyName, int defaultValue) {
        return this.cfg.getInt(this.prefix + propertyName, defaultValue);
    }

    @Override
    public void put(String name, Object value) {
        this.cfg.put(this.prefix + name, value);
    }

    public Object getObject(String propertyName) throws ConfigurationException {
        try {
            Object ret = Class.forName(this.get(propertyName)).newInstance();
            if (ret instanceof Configurable) {
                ((Configurable)ret).setConfiguration(this);
            }
            return ret;
        }
        catch (Exception e) {
            throw new ConfigurationException("Error trying to create an object from property " + this.prefix + propertyName, e);
        }
    }
}

