/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.core;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.jpos.core.Configuration;

public class SimpleConfiguration
implements Configuration {
    private Properties props;

    public SimpleConfiguration() {
        this.props = new Properties();
    }

    public SimpleConfiguration(Properties props) {
        this.props = props;
    }

    public SimpleConfiguration(String filename) throws FileNotFoundException, IOException {
        this.props = new Properties();
        this.load(filename);
    }

    @Override
    public String get(String name, String def) {
        Object obj = this.props.get(name);
        if (obj instanceof List) {
            List l = (List)obj;
            obj = l.size() > 0 ? l.get(0) : null;
        }
        return obj instanceof String ? (String)obj : def;
    }

    @Override
    public String[] getAll(String name) {
        Object obj = this.props.get(name);
        String[] ret = obj instanceof String[] ? (String[])obj : (obj instanceof String ? new String[]{(String)obj} : new String[]{});
        return ret;
    }

    @Override
    public int[] getInts(String name) {
        String[] ss = this.getAll(name);
        int[] ii = new int[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            ii[i] = Integer.parseInt(ss[i].trim());
        }
        return ii;
    }

    @Override
    public long[] getLongs(String name) {
        String[] ss = this.getAll(name);
        long[] ll = new long[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            ll[i] = Long.parseLong(ss[i].trim());
        }
        return ll;
    }

    @Override
    public double[] getDoubles(String name) {
        String[] ss = this.getAll(name);
        double[] dd = new double[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            dd[i] = Double.valueOf(ss[i].trim());
        }
        return dd;
    }

    @Override
    public boolean[] getBooleans(String name) {
        String[] ss = this.getAll(name);
        boolean[] bb = new boolean[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            bb[i] = ss[i].equalsIgnoreCase("true") || ss[i].equalsIgnoreCase("yes");
        }
        return bb;
    }

    @Override
    public String get(String name) {
        return this.get(name, "");
    }

    @Override
    public int getInt(String name) {
        return Integer.parseInt(this.props.getProperty(name, "0").trim());
    }

    @Override
    public int getInt(String name, int def) {
        return Integer.parseInt(this.props.getProperty(name, Integer.toString(def)).trim());
    }

    @Override
    public long getLong(String name) {
        return Long.parseLong(this.props.getProperty(name, "0").trim());
    }

    @Override
    public long getLong(String name, long def) {
        return Long.parseLong(this.props.getProperty(name, Long.toString(def)).trim());
    }

    @Override
    public double getDouble(String name) {
        return Double.valueOf(this.props.getProperty(name, "0.00").trim());
    }

    @Override
    public double getDouble(String name, double def) {
        return Double.valueOf(this.props.getProperty(name, Double.toString(def)).trim());
    }

    @Override
    public boolean getBoolean(String name) {
        String v = this.get(name, "false").trim();
        return v.equalsIgnoreCase("true") || v.equalsIgnoreCase("yes");
    }

    @Override
    public boolean getBoolean(String name, boolean def) {
        String v = this.get(name);
        return v.length() == 0 ? def : v.equalsIgnoreCase("true") || v.equalsIgnoreCase("yes");
    }

    public void load(String filename) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(filename);
        this.props.load(new BufferedInputStream(fis));
        fis.close();
    }

    @Override
    public void put(String name, Object value) {
        this.props.put(name, value);
    }
}

