/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.core;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Date;
import java.util.StringTokenizer;
import org.jpos.core.InvalidCardException;
import org.jpos.iso.ISODate;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOMsg;
import org.jpos.util.Loggeable;

public class CardHolder
implements Cloneable,
Serializable,
Loggeable {
    private static final long serialVersionUID = 7449770625551878435L;
    private static final String TRACK1_SEPARATOR = "^";
    private static final char TRACK2_SEPARATOR = '=';
    private static final int BINLEN = 6;
    private static final int MINPANLEN = 10;
    protected String pan;
    protected String exp;
    protected String trailler;
    protected String securityCode;
    protected String track1;

    public CardHolder() {
    }

    public CardHolder(String track2) throws InvalidCardException {
        this.parseTrack2(track2);
    }

    public CardHolder(String pan, String exp) throws InvalidCardException {
        this.setPAN(pan);
        this.setEXP(exp);
    }

    public CardHolder(ISOMsg m) throws InvalidCardException {
        try {
            if (m.hasField(35)) {
                this.parseTrack2((String)m.getValue(35));
            } else if (m.hasField(2)) {
                this.setPAN((String)m.getValue(2));
                if (m.hasField(14)) {
                    this.setEXP((String)m.getValue(14));
                }
            } else {
                throw new InvalidCardException("required fields not present");
            }
            if (m.hasField(45)) {
                this.setTrack1((String)m.getValue(45));
            }
            if (m.hasField(55)) {
                this.setSecurityCode(m.getString(55));
            }
        }
        catch (ISOException e) {
            throw new InvalidCardException();
        }
    }

    public void parseTrack2(String s) throws InvalidCardException {
        if (s == null) {
            throw new InvalidCardException("null track2 data");
        }
        int separatorIndex = s.replace('D', '=').indexOf(61);
        if (separatorIndex <= 0 || s.length() <= separatorIndex + 4) {
            throw new InvalidCardException(s);
        }
        this.pan = s.substring(0, separatorIndex);
        this.exp = s.substring(separatorIndex + 1, separatorIndex + 1 + 4);
        this.trailler = s.substring(separatorIndex + 1 + 4);
    }

    public void setTrack1(String track1) {
        this.track1 = track1;
    }

    public String getTrack1() {
        return this.track1;
    }

    public boolean hasTrack1() {
        return this.track1 != null;
    }

    public String getNameOnCard() {
        String name = null;
        if (this.track1 != null) {
            StringTokenizer st = new StringTokenizer(this.track1, TRACK1_SEPARATOR);
            if (st.countTokens() < 2) {
                return null;
            }
            st.nextToken();
            name = st.nextToken();
        }
        return name;
    }

    public String getTrack2() {
        if (this.hasTrack2()) {
            return this.pan + '=' + this.exp + this.trailler;
        }
        return null;
    }

    public boolean hasTrack2() {
        return this.pan != null && this.exp != null && this.trailler != null;
    }

    public void setSecurityCode(String securityCode) {
        this.securityCode = securityCode;
    }

    public String getSecurityCode() {
        return this.securityCode;
    }

    public boolean hasSecurityCode() {
        return this.securityCode != null;
    }

    public String getTrailler() {
        return this.trailler;
    }

    public void setTrailler(String trailler) {
        this.trailler = trailler;
    }

    public void setPAN(String pan) throws InvalidCardException {
        if (pan.length() < 10) {
            throw new InvalidCardException(pan);
        }
        this.pan = pan;
    }

    public String getPAN() {
        return this.pan;
    }

    public String getBIN() {
        return this.pan.substring(0, 6);
    }

    public void setEXP(String exp) throws InvalidCardException {
        if (exp.length() != 4) {
            throw new InvalidCardException(this.pan + "/" + exp);
        }
        this.exp = exp;
    }

    public String getEXP() {
        return this.exp;
    }

    public boolean isExpired() {
        if (this.exp == null || this.exp.length() != 4) {
            return true;
        }
        String now = ISODate.formatDate(new Date(), "yyyyMM");
        try {
            String expDate;
            int mm = Integer.parseInt(this.exp.substring(2));
            int aa = Integer.parseInt(this.exp.substring(0, 2));
            if (aa < 100 && mm > 0 && mm <= 12 && (expDate = (aa < 70 ? "20" : "19") + this.exp).compareTo(now) >= 0) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return true;
    }

    public boolean isValidCRC() {
        return CardHolder.isValidCRC(this.pan);
    }

    public static boolean isValidCRC(String p) {
        int odd = p.length() % 2;
        int crc = 0;
        for (int i = 0; i < p.length(); ++i) {
            char c = p.charAt(i);
            if (!Character.isDigit(c)) {
                return false;
            }
            c = (char)(c - 48);
            if (i % 2 == odd) {
                crc += c * 2 >= 10 ? c * 2 - 9 : c * 2;
                continue;
            }
            crc += c;
        }
        return crc % 10 == 0;
    }

    @Override
    public void dump(PrintStream p, String indent) {
        p.print(indent + "<CardHolder");
        if (this.hasTrack1()) {
            p.print(" trk1=\"true\"");
        }
        if (this.hasTrack2()) {
            p.print(" trk2=\"true\"");
        }
        if (this.hasSecurityCode()) {
            p.print(" sec=\"true\"");
        }
        if (this.isExpired()) {
            p.print(" expired=\"true\"");
        }
        p.println(">");
        p.println(indent + "  " + "<pan>" + this.pan + "</pan>");
        p.println(indent + "  " + "<exp>" + this.exp + "</exp>");
        p.println(indent + "</CardHolder>");
    }

    public String getServiceCode() {
        return this.trailler != null && this.trailler.length() >= 3 ? this.trailler.substring(0, 3) : "   ";
    }

    public boolean seemsManualEntry() {
        return this.trailler == null ? true : this.trailler.trim().length() == 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.exp == null ? 0 : this.exp.hashCode());
        result = 31 * result + (this.pan == null ? 0 : this.pan.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CardHolder other = (CardHolder)obj;
        if (this.exp == null ? other.exp != null : !this.exp.equals(other.exp)) {
            return false;
        }
        return !(this.pan == null ? other.pan != null : !this.pan.equals(other.pan));
    }
}

