/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.bsh;

import bsh.Interpreter;
import java.util.Arrays;
import java.util.HashSet;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISORequestListener;
import org.jpos.iso.ISOSource;
import org.jpos.util.Log;

public class BSHRequestListener
extends Log
implements ISORequestListener,
Configurable {
    protected static final String MTI_MACRO = "$mti";
    protected HashSet whitelist;
    protected String[] bshSource;
    Configuration cfg;

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
        this.bshSource = cfg.getAll("source");
        String[] mti = cfg.get("whitelist", "*").split(",");
        this.whitelist = new HashSet<String>(Arrays.asList(mti));
    }

    @Override
    public boolean process(ISOSource source, ISOMsg m) {
        try {
            String mti = m.getMTI();
            if (!this.whitelist.contains(mti) && !this.whitelist.contains("*")) {
                mti = "unsupported";
            }
            for (String aBshSource : this.bshSource) {
                try {
                    Interpreter bsh = new Interpreter();
                    bsh.set("source", (Object)source);
                    bsh.set("message", (Object)m);
                    bsh.set("log", (Object)this);
                    bsh.set("cfg", (Object)this.cfg);
                    int idx = aBshSource.indexOf(MTI_MACRO);
                    String script = idx >= 0 ? aBshSource.substring(0, idx) + mti + aBshSource.substring(idx + MTI_MACRO.length()) : aBshSource;
                    bsh.source(script);
                }
                catch (Exception e) {
                    this.warn(e);
                }
            }
        }
        catch (Exception e) {
            this.warn(e);
            return false;
        }
        return true;
    }
}

