/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.bsh;

import bsh.Interpreter;
import bsh.NameSpace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Map;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.util.LogEvent;
import org.jpos.util.LogListener;

public class BSHLogListener
implements LogListener,
Configurable {
    protected Configuration cfg;
    protected static final String[] patterns = new String[]{"tag", "realm"};
    protected Map<String, ScriptInfo> scripts = new Hashtable<String, ScriptInfo>();

    @Override
    public void setConfiguration(Configuration cfg) {
        this.cfg = cfg;
    }

    protected static String[] replace(String[] src, String[] patterns, String[] to) {
        String[] ret = new String[src.length];
        for (int i = 0; i < src.length; ++i) {
            int begin;
            StringBuilder buff = new StringBuilder(2 * src[i].length());
            int end = 0;
            while ((begin = src[i].indexOf(36, end)) >= 0 && begin < src[i].length()) {
                buff.append(src[i].substring(end, begin));
                boolean patternFound = false;
                for (int k = 0; k < patterns.length && !patternFound; ++k) {
                    patternFound = src[i].indexOf(patterns[k], begin) == begin + 1;
                    if (!patternFound) continue;
                    buff.append(to[k]);
                    end = begin + patterns[k].length() + 1;
                }
                if (patternFound) continue;
                end = begin + 1;
            }
            buff.append(src[i].substring(end));
            ret[i] = buff.toString();
        }
        return ret;
    }

    @Override
    public LogEvent log(LogEvent ev) {
        LogEvent ret = ev;
        boolean processed = false;
        try {
            String[] sources = BSHLogListener.replace(this.cfg.getAll("source"), patterns, new String[]{ev.getTag(), ev.getRealm()});
            for (int i = 0; i < sources.length && ret != null; ++i) {
                try {
                    boolean saveNameSpace;
                    NameSpace ns;
                    Interpreter bsh = new Interpreter();
                    ScriptInfo info = this.getScriptInfo(sources[i]);
                    NameSpace nameSpace = ns = info != null ? info.getNameSpace() : null;
                    if (ns != null) {
                        bsh.setNameSpace(ns);
                    }
                    bsh.set("event", (Object)ret);
                    bsh.set("cfg", (Object)this.cfg);
                    File f = new File(sources[i]);
                    if (!this.cfg.getBoolean("preload-scripts")) {
                        if (f.exists() && f.canRead() && f.isFile()) {
                            processed = true;
                            bsh.eval((Reader)new FileReader(f));
                        }
                    } else {
                        if (info == null) {
                            info = new ScriptInfo();
                            this.scripts.put(sources[i], info);
                        }
                        if (System.currentTimeMillis() > info.getLastCheck() + this.cfg.getLong("reload")) {
                            info.setLastCheck(System.currentTimeMillis());
                            if (f.exists() && f.canRead() && f.isFile()) {
                                if (info.getLastModified() != f.lastModified()) {
                                    info.setLastModified(f.lastModified());
                                    info.setCode(this.loadCode(f));
                                }
                            } else {
                                info.setCode(null);
                            }
                        }
                        if (info.getCode() != null) {
                            processed = true;
                            bsh.eval((Reader)new StringReader(info.getCode()));
                        } else {
                            this.scripts.remove(sources[i]);
                        }
                    }
                    ret = (LogEvent)bsh.get("event");
                    Object saveNS = bsh.get("saveNameSpace");
                    boolean bl = saveNameSpace = saveNS instanceof Boolean ? ((Boolean)saveNS).booleanValue() : this.cfg.getBoolean("save-name-space");
                    if (saveNameSpace) {
                        if (info != null) {
                            info.setNameSpace(bsh.getNameSpace());
                            continue;
                        }
                        this.scripts.put(sources[i], new ScriptInfo(bsh.getNameSpace()));
                        continue;
                    }
                    if (info == null) continue;
                    info.setNameSpace(null);
                    continue;
                }
                catch (Exception e) {
                    ret.addMessage(e);
                }
            }
            return !processed && this.cfg.getBoolean("filter-by-default") ? null : ret;
        }
        catch (Exception e) {
            ret.addMessage(e);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loadCode(File f) throws IOException {
        StringBuilder buf = new StringBuilder((int)f.length());
        char[] content = new char[(int)f.length()];
        BufferedReader r = new BufferedReader(new FileReader(f));
        try {
            int l;
            while ((l = r.read(content)) != -1) {
                buf.append(content, 0, l);
            }
        }
        finally {
            ((Reader)r).close();
        }
        return buf.toString();
    }

    protected ScriptInfo getScriptInfo(String filename) {
        return this.scripts.get(filename);
    }

    protected void addScriptInfo(String filename, String code, long lastModified) {
        this.scripts.put(filename, new ScriptInfo(code, lastModified));
    }

    protected static class ScriptInfo {
        String code;
        long lastModified;
        long lastCheck;
        NameSpace nameSpace;

        public ScriptInfo() {
        }

        public ScriptInfo(NameSpace ns) {
            this.nameSpace = ns;
        }

        public ScriptInfo(String code, long lastModified) {
            this.setCode(code);
            this.setLastModified(lastModified);
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        public long getLastCheck() {
            return this.lastCheck;
        }

        public void setLastCheck(long lastCheck) {
            this.lastCheck = lastCheck;
        }

        public NameSpace getNameSpace() {
            return this.nameSpace;
        }

        public void setNameSpace(NameSpace nameSpace) {
            this.nameSpace = nameSpace;
        }
    }
}

