/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.bsh;

import bsh.Interpreter;
import bsh.TargetError;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISOChannel;
import org.jpos.iso.ISOFilter;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.RawIncomingFilter;
import org.jpos.util.LogEvent;

public class BSHFilter
implements RawIncomingFilter,
Configurable {
    Configuration cfg;

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
    }

    @Override
    public ISOMsg filter(ISOChannel channel, ISOMsg m, LogEvent evt) throws ISOFilter.VetoException {
        return this.filter(channel, m, null, null, evt);
    }

    @Override
    public ISOMsg filter(ISOChannel channel, ISOMsg m, byte[] header, byte[] image, LogEvent evt) throws ISOFilter.VetoException {
        String[] source;
        for (String aSource : source = this.cfg.getAll("source")) {
            try {
                Interpreter bsh = new Interpreter();
                bsh.set("channel", (Object)channel);
                bsh.set("message", (Object)m);
                if (header != null) {
                    bsh.set("header", (Object)header);
                }
                if (image != null) {
                    bsh.set("image", (Object)image);
                }
                bsh.set("evt", (Object)evt);
                bsh.set("cfg", (Object)this.cfg);
                Object r = bsh.source(aSource);
                if (r instanceof ISOMsg) {
                    m = (ISOMsg)r;
                    continue;
                }
                m = (ISOMsg)bsh.get("message");
            }
            catch (TargetError e) {
                if (!(e.getTarget() instanceof ISOFilter.VetoException)) continue;
                throw (ISOFilter.VetoException)e.getTarget();
            }
            catch (Exception e) {
                if (e instanceof ISOFilter.VetoException) {
                    throw (ISOFilter.VetoException)e;
                }
                evt.addMessage(e);
            }
        }
        return m;
    }
}

